<?php

namespace App\Http\Controllers\Api\Admin;
use App\Http\Controllers\ResponseController;
use App\Models\Admin;
use Illuminate\Support\Facades\Auth;
use App\Http\Controllers\Controller;

class LoginController extends Controller
{
    public function get()
    {

        $this->validate(request(), [
            'email' => 'required|email|max:225',
            'password' => 'required|string|min:8|max:35',
        ]);
//        $remember = request()->has('remember') ? true : false;
        $credentials = request(['email', 'password']);
        $checkLogin = Auth::guard('admin')->attempt($credentials);
        if (!$checkLogin) {
            session()->flash('message', 'البيانات غير صحيحة');
//            return redirect('admin/login');

            return response()->json(['data' => $checkLogin, 'message' => trans('بينات خاطئة'), 'status' => trans('0')]);

        } else {
           
            $data['username'] = request()->username;
            $data ['email'] = request()->email;
          
            // $data = Admin::where('email', request()->email)->first();
//            return response()->json(['data' => $data, 'message' => trans('تم تسجيل الدخول بنجاح'), 'status' => trans('1')], 200);
            return response()->json(['data' => $data, 'message' => trans('user.login.login_success')]);
        }





    }

    public function post()
    {
//       dd(request()->all());
        $this->validate(request(), [
            'email' => 'required|email|max:225',
            'password' => 'required|string|min:8|max:35',
        ]);


        $remember = request()->has('remember') ? true : false;
        $credentials = array('email' => request()->email, 'password' => request()->password);
        $checkLogin = Auth::guard('admin')->attempt($credentials, $remember);
        if (!$checkLogin) {
            session()->flash('message', 'البيانات غير صحيحة');
            return redirect('admin/login');

        }
        return redirect('/dashboard/');

    }

    public function logout()
    {
        auth()->guard('admin')->logout();
        return redirect('/admin/login');
    }
}
