<?php $__env->startSection('css'); ?>
    <link id="gull-theme" rel="stylesheet" href="<?php echo e(asset('assets')); ?>/styles/css/image.css">
<?php $__env->stopSection(); ?>

<!-- ============ Body content start ============= -->
<?php $__env->startSection('content'); ?>
    <div class="breadcrumb">
        <a href="<?php echo e(route('dashboard.home')); ?>"><h1>الرئيسية</h1></a>
        <ul>
            <li><a> القرى</a></li>
        </ul>
    </div>

    <div class="separator-breadcrumb border-top"></div>

    <div class="row">
        <div class="col-md-12">
            <div class="card mb-4">
                <div class="card-header">
                    <div class="card-title mb-3">  <strong class="text-primary">إضافة قرية</strong></div>
                </div>
                <?php echo $__env->make('dashboard.layouts.message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                <div class="card-body">
                    <form id="change-pwd" action="<?php echo e(url('dashboard/village/store')); ?>" method="post" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <div class="row">

                            <div class="col-md-6 form-group mb-3">
                                <label for="village">الإسم </label>
                                <input type="text" class="form-control" name="village" id="village" placeholder="الإسم " value="<?php echo e(old('village')); ?>" autocomplete="off">
                                <?php if($errors->has('village')): ?>
                                    <span class="text-danger" role="alert">
                                        <strong><?php echo e($errors->first('village')); ?> </strong>
                                    </span>
                                <?php endif; ?>
                            </div>

                            <div class="col-md-6 form-group mb-3">
                                <label for="shipping_cost">تكلفة الشحن </label>
                                <input type="text" class="form-control" name="shipping_cost" id="shipping_cost" placeholder="تكلفة الشحن" value="<?php echo e(old('shipping_cost')); ?>" autocomplete="off">
                                <?php if($errors->has('shipping_cost')): ?>
                                    <span class="text-danger" role="alert">
                                        <strong><?php echo e($errors->first('shipping_cost')); ?> </strong>
                                    </span>
                                <?php endif; ?>
                            </div>

                            <div class="col-md-6 form-group mb-3">
                                <label for="state"> المحافظة</label>
                                <select class="form-control attribute" name="state" id="state" >
                                    <option selected disabled>اختر المحافظة </option>
                                    <?php $__currentLoopData = $states; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $state): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($state->id); ?>"><?php echo e($state->state); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <?php if($errors->has('state')): ?>
                                    <span class="text-danger" role="alert">
                                        <strong><?php echo e($errors->first('state')); ?> </strong>
                                    </span>
                                <?php endif; ?>
                            </div>

                            <div class="col-md-6 form-group mb-3">
                                <label for="city"> المدينة</label>
                                <select class="form-control attribute" name="city" id="city" >
                                    <option selected disabled>اختر المحافظة أولا </option>

                                </select>
                                <?php if($errors->has('city')): ?>
                                    <span class="text-danger" role="alert">
                                        <strong><?php echo e($errors->first('city')); ?> </strong>
                                    </span>
                                <?php endif; ?>
                            </div>











                            <div class="col-md-12">
                                <button class="btn btn-primary">حفظ</button>
                            </div>
                        </div>
                    </form>

                </div>
            </div>
        </div>
    </div>


<?php $__env->stopSection(); ?>
<!-- ============ Body content End ============= -->
<?php $__env->startSection('js'); ?>
    <script src="<?php echo e(asset('assets')); ?>/js/image.js"></script>
    <script>
        $(document).ready(function () {
            'use strict';

            $(document).on('change','#state',function (event) {

                event.preventDefault();
                var id = $(this).val();
                var url = "<?php echo e(url('dashboard/city/state_cities')); ?>"+'/'+id;
                $.ajax({
                    url:url,
                    dataType:'json',
                    type:'get',
                    // data:{id:id},
                    // mimeType: "multipart/form-data",
                    contentType: false,
                    cache: false,
                    processData: false,
                    beforeSend:function(){
                        // alert(url);
                    },
                    success:function (data) {
                        if (data.status == 1){
                            $('#city option').remove();
                            $('#city').append("<option selected disabled>اختر المدينة</option>");
                            $.each(data.data,function (index,value) {
                                // console.log(data.data);
                                $('#city').append("<option value="+value.id+">"+value.city +"</option>");
                            });
                        }
                    }
                });
            });
        });


    </script>

    <script src="https://cdn.jsdelivr.net/jquery.validation/1.16.0/jquery.validate.min.js"></script>
    <script src="https://cdn.jsdelivr.net/jquery.validation/1.16.0/additional-methods.min.js"></script>
    <script>
        $("#form").validate({
            // Specify the validation rules
            rules: {
                name: {
                    required: true,
                    alpha: true
                },
                url: {
                    required: true,
                    url:true,
                },

            },
            // Specify the validation error messages
            messages: {
                name: {
                    required: 'يرجى إدخال اسم الموقع ',
                    alpha: 'يجب ان يتكون اسم الموقع من حروف فقط ',
                },
                url: {
                    required: 'يرجى إدخال رابط الموقع  ',
                    url:'برجاء ادخال رابط صحيح',
                },
            },
            submitHandler: function (form) {
                form.submit();
            },
            highlight: function (element) {
                $(element).closest('.form-group').removeClass('has-success').addClass('has-error');
                $(element).closest('.form-group').find('.glyphicon').removeClass('glyphicon-ok').addClass('glyphicon-remove');
            },
            unhighlight: function (element) {
                $(element).closest('.form-group').removeClass('has-error').addClass('has-success');
                $(element).closest('.form-group').find('.glyphicon').removeClass('glyphicon-remove').addClass('glyphicon-ok');
            },
            errorElement: 'span',
            errorClass: 'help-block',
            errorPlacement: function (error, element) {
                if (element.parent('.input-group').length) {
                    error.insertAfter(element.parent());
                } else if (element.closest('.form-group').find('.cke').length) {
                    error.appendTo(element.closest('.form-group'));
                } else {
                    error.insertAfter(element);
                }
            }
        });
    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('dashboard.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\wasly\resources\views/dashboard/village/create.blade.php ENDPATH**/ ?>