<?php $__env->startSection('css'); ?>
    <link id="gull-theme" rel="stylesheet" href="<?php echo e(asset('assets')); ?>/styles/css/image.css">
<?php $__env->stopSection(); ?>

<!-- ============ Body content start ============= -->
<?php $__env->startSection('content'); ?>
    <div class="breadcrumb">
        <a href="<?php echo e(route('dashboard.home')); ?>"><h1>الرئيسية</h1></a>
        <ul>
            <li><a> البراندات</a></li>
        </ul>
    </div>

    <div class="separator-breadcrumb border-top"></div>

    <div class="row">
        <div class="col-md-12">
            <div class="card mb-4">
                <div class="card-header">
                    <div class="card-title mb-3">  <strong class="text-primary">إضافة براند</strong></div>
                </div>
                <?php echo $__env->make('dashboard.layouts.message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                <div class="card-body">
                    <form id="change-pwd" action="<?php echo e(url('dashboard/brand/store')); ?>" method="post" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <div class="row">
                            <div class="col-md-12">
                                <h3 class="text-center">الصورة</h3>
                                <div class="avatar-upload">
                                    <div class="avatar-edit">
                                        <input type='file' name="image" id="imageUpload" />
                                        <label for="imageUpload"></label>
                                    </div>
                                    <div class="avatar-preview">
                                        <div id="imagePreview">
                                        </div>
                                    </div>
                                </div>
                                <?php if($errors->has('image')): ?>
                                    <span class="text-danger" role="alert">
                                        <strong><?php echo e($errors->first('image')); ?></strong>
                                    </span>
                                <?php endif; ?>
                            </div>

                            <div class="col-md-6 form-group mb-3">
                                <label for="title">الإسم </label>
                                <input type="text" class="form-control" name="title" id="title" placeholder="الإسم " value="<?php echo e(old('title')); ?>" autocomplete="off">
                                <?php if($errors->has('title')): ?>
                                    <span class="text-danger" role="alert">
                                        <strong><?php echo e($errors->first('title')); ?> </strong>
                                    </span>
                                <?php endif; ?>
                            </div>

                            <div class="col-md-6 form-group mb-3">
                                <label for="category"> القسم</label>
                                <select class="form-control attribute" name="category" id="category" >
                                    <option selected disabled>اختر القسم </option>
                                    <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($category->id); ?>"><?php echo e($category->title); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <?php if($errors->has('category')): ?>
                                    <span class="text-danger" role="alert">
                                        <strong><?php echo e($errors->first('category')); ?> </strong>
                                    </span>
                                <?php endif; ?>
                            </div>

                            <div class="col-md-6 form-group mb-3">
                                <label for="city"> المدينة</label>
                                <select class="form-control attribute" name="city" id="city" >
                                    <option selected disabled>اختر المدينة </option>
                                    <?php $__currentLoopData = $cities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $city): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($city->id); ?>"><?php echo e($city->city); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <?php if($errors->has('city')): ?>
                                    <span class="text-danger" role="alert">
                                        <strong><?php echo e($errors->first('city')); ?> </strong>
                                    </span>
                                <?php endif; ?>
                            </div>
                          <div class="col-md-6 form-group mb-3">
                              <label for="title_en">الإسم الانجليزي</label>
                              <input type="text" class="form-control" name="title_en" id="title_en" placeholder="الإسم الإنجليزي" value="<?php echo e(old('title_en')); ?>" autocomplete="off">
                              <?php if($errors->has('title_en')): ?>
                                  <span class="text-danger" role="alert">
                                      <strong>هذا الحقل مطلوب و يجب أن يكون باللغة الإنجليزية</strong>
                                  </span>
                              <?php endif; ?>
                       </div>


                            <div class="col-md-12">
                                <button class="btn btn-primary">حفظ</button>
                            </div>
                        </div>
                    </form>

                </div>
            </div>
        </div>
    </div>


<?php $__env->stopSection(); ?>
<!-- ============ Body content End ============= -->
<?php $__env->startSection('js'); ?>
    <script src="<?php echo e(asset('assets')); ?>/js/image.js"></script>
    <script>
        function readURL(input) {
            if (input.files && input.files[0]) {
                var reader = new FileReader();
                reader.onload = function(e) {
                    $('#imagePreview').css('background-image', 'url('+e.target.result +')');
                    $('#imagePreview').hide();
                    $('#imagePreview').fadeIn(650);
                };
                reader.readAsDataURL(input.files[0]);
            }
        }
        $("#imageUpload").change(function() {
            readURL(this);
        });

    </script>

    <script src="https://cdn.jsdelivr.net/jquery.validation/1.16.0/jquery.validate.min.js"></script>
    <script src="https://cdn.jsdelivr.net/jquery.validation/1.16.0/additional-methods.min.js"></script>
    <script>
        $("#form").validate({
            // Specify the validation rules
            rules: {
                name: {
                    required: true,
                    alpha: true
                },
                url: {
                    required: true,
                    url:true,
                },

            },
            // Specify the validation error messages
            messages: {
                name: {
                    required: 'يرجى إدخال اسم الموقع ',
                    alpha: 'يجب ان يتكون اسم الموقع من حروف فقط ',
                },
                url: {
                    required: 'يرجى إدخال رابط الموقع  ',
                    url:'برجاء ادخال رابط صحيح',
                },
            },
            submitHandler: function (form) {
                form.submit();
            },
            highlight: function (element) {
                $(element).closest('.form-group').removeClass('has-success').addClass('has-error');
                $(element).closest('.form-group').find('.glyphicon').removeClass('glyphicon-ok').addClass('glyphicon-remove');
            },
            unhighlight: function (element) {
                $(element).closest('.form-group').removeClass('has-error').addClass('has-success');
                $(element).closest('.form-group').find('.glyphicon').removeClass('glyphicon-remove').addClass('glyphicon-ok');
            },
            errorElement: 'span',
            errorClass: 'help-block',
            errorPlacement: function (error, element) {
                if (element.parent('.input-group').length) {
                    error.insertAfter(element.parent());
                } else if (element.closest('.form-group').find('.cke').length) {
                    error.appendTo(element.closest('.form-group'));
                } else {
                    error.insertAfter(element);
                }
            }
        });
    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('dashboard.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\wasly\resources\views/dashboard/brand/create.blade.php ENDPATH**/ ?>