<!-- ============ Body content start ============= -->
<?php $__env->startSection('content'); ?>
    <div class="breadcrumb">
        <a href="<?php echo e(route('dashboard.home')); ?>"><h1>الرئيسية</h1></a>
        <ul>
            <li><a> أضافة مدير</a></li>
        </ul>
    </div>

    <div class="separator-breadcrumb border-top"></div>

    <div class="row">
        <div class="col-md-12">
            <div class="card mb-4">
                <div class="card-header">
                    <div class="card-title mb-3"> <strong class="text-primary">الاضافة</strong> </div>
                </div>
                <?php echo $__env->make('dashboard.layouts.message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                <div class="card-body">
                    <form id="change-pwd" action="<?php echo e(url('dashboard/admin/store')); ?>" method="post">
                        <?php echo csrf_field(); ?>
                        <div class="row">
                            <div class="col-md-6 form-group mb-3">
                                <label for="username">الإسم</label>
                                <input type="text" class="form-control" name="username" id="username" placeholder="الإسم" value="<?php echo e(old('username')); ?>" autocomplete="off">
                                <?php if($errors->has('username')): ?>
                                    <span class="text-danger" role="alert">
                                        <strong>الإسم مطلوب</strong>
                                    </span>
                                <?php endif; ?>
                            </div>

                            <div class="col-md-6 form-group mb-3">
                                <label for="email">البريد الإلكتروني</label>
                                <input type="email" class="form-control" name="email" id="email" placeholder="البريد الإلكتروني" value="<?php echo e(old('email')); ?>" autocomplete="off">
                                <?php if($errors->has('email')): ?>
                                    <span class="text-danger" role="alert">
                                        <strong>البريد الإلكتروني مطلوب</strong>
                                    </span>
                                <?php endif; ?>
                            </div>

                            <div class="col-md-6 form-group mb-3">
                                <label for="role"> الصلاحيات</label>
                                <select class="form-control attribute" name="role" id="role" >
                                    <option selected disabled>اختر الصلاحية </option>
                                        <option value="1">مدير</option>
                                        <option value="2">موظف</option>
                                </select>
                                <?php if($errors->has('role')): ?>
                                    <span class="text-danger" role="alert">
                                        <strong><?php echo e($errors->first('role')); ?> </strong>
                                    </span>
                                <?php endif; ?>
                            </div>
                            </div>
                        <div class="row">

                            <div class="col-md-6 form-group mb-3">
                                <label for="password">كلمة المرور</label>
                                <input type="password" class="form-control" name="password" id="password" placeholder="كلمة المرور ">
                                <?php if($errors->has('password')): ?>
                                    <span class="text-danger" role="alert">
                                        <strong>كلمه المرور مطلوبه ويجب ان لا تقل عن 8 حروف او ارقام</strong>
                                    </span>
                                <?php endif; ?>
                            </div>

                            <div class="col-md-6 form-group mb-3">
                                <label for="password_confirmation">تأكيد كلمة المرور</label>
                                <input type="password" class="form-control" name="password_confirmation" id="password_confirmation" placeholder="تأكيد كلمة المرور ">
                                <?php if($errors->has('password_confirmation')): ?>
                                    <span class="text-danger" role="alert">
                                        <strong>يجب تأكيد كلمة المرور</strong>
                                    </span>
                                <?php endif; ?>
                            </div>
                        </div>
                            <div class="col-md-12">
                                <button class="btn btn-primary">حفظ</button>
                            </div>
                        </div>
                    </form>

                </div>
            </div>
        </div>
    </div>


<?php $__env->stopSection(); ?>
<!-- ============ Body content End ============= -->
<?php $__env->startSection('js'); ?>
    <script src="https://cdn.jsdelivr.net/jquery.validation/1.16.0/jquery.validate.min.js"></script>
    <script src="https://cdn.jsdelivr.net/jquery.validation/1.16.0/additional-methods.min.js"></script>
    <script>
        $("#form").validate({
            // Specify the validation rules
            rules: {
                name: {
                    required: true,
                    alpha: true
                },
                url: {
                    required: true,
                    url:true,
                },

            },
            // Specify the validation error messages
            messages: {
                name: {
                    required: 'يرجى إدخال اسم الموقع ',
                    alpha: 'يجب ان يتكون اسم الموقع من حروف فقط ',
                },
                url: {
                    required: 'يرجى إدخال رابط الموقع  ',
                    url:'برجاء ادخال رابط صحيح',
                },
            },
            submitHandler: function (form) {
                form.submit();
            },
            highlight: function (element) {
                $(element).closest('.form-group').removeClass('has-success').addClass('has-error');
                $(element).closest('.form-group').find('.glyphicon').removeClass('glyphicon-ok').addClass('glyphicon-remove');
            },
            unhighlight: function (element) {
                $(element).closest('.form-group').removeClass('has-error').addClass('has-success');
                $(element).closest('.form-group').find('.glyphicon').removeClass('glyphicon-remove').addClass('glyphicon-ok');
            },
            errorElement: 'span',
            errorClass: 'help-block',
            errorPlacement: function (error, element) {
                if (element.parent('.input-group').length) {
                    error.insertAfter(element.parent());
                } else if (element.closest('.form-group').find('.cke').length) {
                    error.appendTo(element.closest('.form-group'));
                } else {
                    error.insertAfter(element);
                }
            }
        });
    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('dashboard.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\wasly\resources\views/dashboard/admin/create.blade.php ENDPATH**/ ?>